#include <iostream>
#include <vector>

using namespace std;

void dodajZalbe(vector<int>& kapaciteti, vector<int>& zalihe, vector<pair<int, int>>& upiti)
{
    for (auto & upit : upiti)
    {
        int clan = upit.first;
        int z = upit.second;

        while (z > 0 && clan < kapaciteti.size())
        {
            int preostalo = kapaciteti[clan] - zalihe[clan];
            if (preostalo >= z)
            {
                zalihe[clan] += z;
                z = 0;
            }
            else
            {
                z -= preostalo;
                zalihe[clan] = kapaciteti[clan];
                clan++;
            }
        }
    }
}

void ispisiZalbe(const vector<int>& zalihe)
{
    for (int z : zalihe)
    {
        cout << z << " ";
    }
    cout << endl;
}

int main()
{
    int N;
    cin >> N;

    vector<int> zalihe(N);
    vector<int> kapaciteti(N);

    for (int i = 0; i < N; i++)
    {
        cin >> zalihe[i];
    }

    for (int i = 0; i < N; i++)
    {
        cin >> kapaciteti[i];
    }

    int Q;
    cin >> Q;

    vector<pair<int, int>> upiti(Q);
    for (int i = 0; i < Q; i++)
    {
        int clan, z;
        cin >> clan >> z;
        upiti[i] = make_pair(clan - 1, z); 
    }

    dodajZalbe(kapaciteti, zalihe, upiti);
    ispisiZalbe(zalihe);

    return 0;
}